#ifndef __IMenuListener__
#define __IMenuListener__

#include "../Events/CMenuEvent.hpp"
using Exponent::GUI::Events::CMenuEvent;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IMenuListener IMenuListener.hpp
			 * @brief Allows for responding to menu changes
			 *
			 * @date 15/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IMenuListener.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface IMenuListener
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IMenuListener() { }
				
				/**
				 * Destruction
				 */
				virtual ~IMenuListener() { }

//	===========================================================================

				/**
				 * Handle a menu opening
				 * @param event The event to handle
				 */
				virtual void handleMenuOpening(const CMenuEvent &event)   = 0;

				/**
				 * Handle a menu closing
				 * @param event The event to handle
				 */
				virtual void handleMenuClosing(const CMenuEvent &event)   = 0;

				/**
				 * Handle a menu selection
				 * @param event The event to handle
				 */
				virtual void handleMenuSelection(const CMenuEvent &event) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IMenuListener.hpp